'/***
'*ctype.h - character conversion macros and ctype macros
'*
'*       Copyright (c) 1985-2001, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       Defines macros for character classification/conversion.
'*       [ANSI/System V]
'*
'*       [Public]
'*
'****/

#If Not %Def(%CTYPE_INC)
    %CTYPE_INC = 1

'typedef unsigned short wchar_t;
'typedef unsigned short wint_t;
'typedef unsigned short wctype_t;

#If Not %Def(%WEOF)
'#define WEOF (wint_t)(0xFFFF)
%WEOF = &HFFFF??
#EndIf

'/* set bit masks for the possible character types */

'#define _UPPER          0x1     /* upper case letter */
'#define _LOWER          0x2     /* lower case letter */
'#define _DIGIT          0x4     /* digit[0-9] */
'#define _SPACE          0x8     /* tab, carriage return, newline, */
'                                /* vertical tab or form feed */
'#define _PUNCT          0x10    /* punctuation character */
'#define _CONTROL        0x20    /* control character */
'#define _BLANK          0x40    /* space char */
'#define _HEX            0x80    /* hexadecimal digit */

'#define _LEADBYTE       0x8000                  /* multibyte leadbyte */
'#define _ALPHA          (0x0100|_UPPER|_LOWER)  /* alphabetic character */

%UPPER_          = &H1&    ' /* upper case letter */
%LOWER_          = &H2&    ' /* lower case letter */
%DIGIT_          = &H4&    ' /* digit[0-9] */
%SPACE_          = &H8&    ' /* tab, carriage return, newline, */
                           ' /* vertical tab or form feed */
%PUNCT_          = &H10&   ' /* punctuation character */
%CONTROL_        = &H20&   ' /* control character */
%BLANK_          = &H40&   ' /* space char */
%HEX_            = &H80&   ' /* hexadecimal digit */

%LEADBYTE_       = &H8000&                         ' /* multibyte leadbyte */
%ALPHA_          = &H0100& Or %UPPER_ Or %LOWER_   ' /* alphabetic character */


'/* character classification function prototypes */

#If Not %Def(%CTYPE_DEFINED)
    %CTYPE_DEFINED = 1

'_CRTIMP int __cdecl _isctype(int, int);
Declare Function isctype CDecl Lib "msvcrt.dll" Alias "_isctype" (_
   ByVal Long, _                            ' int c
   ByVal Long _                             ' _ctype_t desc
   ) As Long                                ' int

'_CRTIMP int __cdecl isalpha(int);
Declare Function isalpha CDecl Lib "msvcrt.dll" Alias "isalpha" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl isupper(int);
Declare Function isupper CDecl Lib "msvcrt.dll" Alias "isupper" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl islower(int);
Declare Function islower CDecl Lib "msvcrt.dll" Alias "islower" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl isdigit(int);
Declare Function isdigit CDecl Lib "msvcrt.dll" Alias "isdigit" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl isxdigit(int);
Declare Function isxdigit CDecl Lib "msvcrt.dll" Alias "isxdigit" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl isspace(int);
Declare Function isspace CDecl Lib "msvcrt.dll" Alias "isspace" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl ispunct(int);
Declare Function ispunct CDecl Lib "msvcrt.dll" Alias "ispunct" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl isalnum(int);
Declare Function isalnum CDecl Lib "msvcrt.dll" Alias "isalnum" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl isprint(int);
Declare Function isprint CDecl Lib "msvcrt.dll" Alias "isprint" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl isgraph(int);
Declare Function isgraph CDecl Lib "msvcrt.dll" Alias "isgraph" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl iscntrl(int);
Declare Function iscntrl CDecl Lib "msvcrt.dll" Alias "iscntrl" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl toupper(int);
Declare Function toupper CDecl Lib "msvcrt.dll" Alias "toupper" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _toupper(int);
Declare Function toupper_ CDecl Lib "msvcrt.dll" Alias "_toupper" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl tolower(int);
Declare Function tolower CDecl Lib "msvcrt.dll" Alias "tolower" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _tolower(int);
Declare Function tolower_ CDecl Lib "msvcrt.dll" Alias "_tolower" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl __isascii(int);
Declare Function isascii_ CDecl Lib "msvcrt.dll" Alias "__isascii" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl __toascii(int);
Declare Function toascii_ CDecl Lib "msvcrt.dll" Alias "__toascii" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl __iscsymf(int);
Declare Function iscsymf_ CDecl Lib "msvcrt.dll" Alias "__iscsymf" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl __iscsym(int);
Declare Function iscsym_ CDecl Lib "msvcrt.dll" Alias "__iscsym" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

#EndIf   ' #IF NOT %DEF(%CTYPE_DEFINED)

#If Not %Def(%WCTYPE_DEFINED)
    %WCTYPE_DEFINED = 1

'/* wide function prototypes, also declared in wchar.h  */

'/* character classification function prototypes */

'_CRTIMP int __cdecl iswalpha(wint_t);
Declare Function iswalpha CDecl Lib "msvcrt.dll" Alias "iswalpha" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswupper(wint_t);
Declare Function iswupper CDecl Lib "msvcrt.dll" Alias "iswupper" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswlower(wint_t);
Declare Function iswlower CDecl Lib "msvcrt.dll" Alias "iswlower" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswdigit(wint_t);
Declare Function iswdigit CDecl Lib "msvcrt.dll" Alias "iswdigit" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswxdigit(wint_t);
Declare Function iswxdigit CDecl Lib "msvcrt.dll" Alias "iswxdigit" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswspace(wint_t);
Declare Function iswspace CDecl Lib "msvcrt.dll" Alias "iswspace" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswpunct(wint_t);
Declare Function iswpunct CDecl Lib "msvcrt.dll" Alias "iswpunct" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswalnum(wint_t);
Declare Function iswalnum CDecl Lib "msvcrt.dll" Alias "iswalnum" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswprint(wint_t);
Declare Function iswprint CDecl Lib "msvcrt.dll" Alias "iswprint" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswgraph(wint_t);
Declare Function iswgraph CDecl Lib "msvcrt.dll" Alias "iswgraph" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswcntrl(wint_t);
Declare Function iswcntrl CDecl Lib "msvcrt.dll" Alias "iswcntrl" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswascii(wint_t);
Declare Function iswascii CDecl Lib "msvcrt.dll" Alias "iswascii" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl isleadbyte(int);
Declare Function isleadbyte CDecl Lib "msvcrt.dll" Alias "isleadbyte" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP wchar_t __cdecl towupper(wchar_t);
Declare Function towupper CDecl Lib "msvcrt.dll" Alias "towupper" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP wchar_t __cdecl towlower(wchar_t);
Declare Function towlower CDecl Lib "msvcrt.dll" Alias "towlower" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'_CRTIMP int __cdecl iswctype(wint_t, wctype_t);
Declare Function iswctype CDecl Lib "msvcrt.dll" Alias "iswctype" ( _
   ByVal Word _                             ' wint_t c
   ) As Long                                ' int

'/* --------- The following functions are OBSOLETE --------- */
'_CRTIMP int __cdecl is_wctype(wint_t, wctype_t);
'DECLARE FUNCTION is_wctype CDECL LIB "msvcrt.dll" ALIAS "is_wctype" ( _
'   BYVAL WORD _                             ' wint_t c
'   ) AS LONG                                ' int
'/*  --------- The preceding functions are OBSOLETE --------- */

#EndIf   ' #IF NOT %DEF(%WCTYPE_DEFINED)

'/*
' * Maximum number of bytes in multi-byte character in the current locale
' * (also defined in stdlib.h).
' */
#If Not %Def(%MB_CUR_MAX)
%MB_CUR_MAX = 1

' Note: We need to use CALL instead of the function form in the calls to LoadLibrary,
' FreeLibrary and GetProcAddress because these are defined in winbase.inc, included
' later.

'_CRTIMP extern int __mb_cur_max;
Function pb_mb_cur_max () As Long
   Local hLib As Dword
   Local pmbcurmax As Long Ptr
   Call LoadLibrary("msvcrt.dll") To hLib
   If hLib Then
      Call GetProcAddress(hLib, "__mb_cur_max") To pmbcurmax
      If pmbcurmax Then Function = @pmbcurmax
      Call FreeLibrary(hLib)
   End If
End Function

'_CRTIMP int __cdecl ___mb_cur_max_func(void);
Function pb_mb_cur_max_func CDecl () As Long
   Local hLib As Dword
   Local pbcurmax As Long
   Local pmbcurmaxfunc As Dword
   Call LoadLibrary("msvcrt.dll") To hLib
   If hLib Then
      Call GetProcAddress(hLib, "___mb_cur_max_func") To pmbcurmaxfunc
      If pmbcurmaxfunc Then
         Call Dword pmbcurmaxfunc Using pb_mb_cur_max_func() To pbcurmax
         Function = pbcurmax
      End If
      Call FreeLibrary(hLib)
   End If
End Function
#EndIf   '  /* MB_CUR_MAX */

#EndIf   ' #IF NOT %DEF(%CTYPE_INC)